/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.util.listenable;

import com.ochafik.util.listenable.CollectionListener;
import com.ochafik.util.listenable.DefaultListenableCollection;
import com.ochafik.util.listenable.ListenableSupport;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SynchronizedListenableCollection<T>
extends DefaultListenableCollection<T> {
    protected Object mutex;

    public SynchronizedListenableCollection(Collection<T> collection, ListenableSupport<T> collectionSupport) {
        super(collection, collectionSupport);
        this.mutex = this;
    }

    public SynchronizedListenableCollection(Collection<T> collection) {
        super(collection);
        this.mutex = this;
    }

    public SynchronizedListenableCollection(Collection<T> collection, ListenableSupport<T> collectionSupport, Object mutex) {
        super(collection, collectionSupport);
        this.mutex = mutex;
    }

    public SynchronizedListenableCollection(Collection<T> collection, Object mutex) {
        super(collection);
        this.mutex = mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(T o) {
        Object object = this.mutex;
        synchronized (object) {
            return super.add(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends T> c) {
        Object object = this.mutex;
        synchronized (object) {
            return super.addAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCollectionListener(CollectionListener<T> l) {
        Object object = this.mutex;
        synchronized (object) {
            super.addCollectionListener(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.mutex;
        synchronized (object) {
            super.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object clone() throws CloneNotSupportedException {
        Object object = this.mutex;
        synchronized (object) {
            return super.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        Object object = this.mutex;
        synchronized (object) {
            return super.contains(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> c) {
        Object object = this.mutex;
        synchronized (object) {
            return super.containsAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object obj) {
        Object object = this.mutex;
        synchronized (object) {
            return super.equals(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        Object object = this.mutex;
        synchronized (object) {
            return super.hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.mutex;
        synchronized (object) {
            return super.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<T> iterator() {
        Object object = this.mutex;
        synchronized (object) {
            return new SynchronizedListenableIterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        Object object = this.mutex;
        synchronized (object) {
            return super.remove(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        Object object = this.mutex;
        synchronized (object) {
            return super.removeAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCollectionListener(CollectionListener<T> l) {
        Object object = this.mutex;
        synchronized (object) {
            super.removeCollectionListener(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        Object object = this.mutex;
        synchronized (object) {
            return super.retainAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.mutex;
        synchronized (object) {
            return super.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        Object object = this.mutex;
        synchronized (object) {
            return super.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> V[] toArray(V[] a) {
        Object object = this.mutex;
        synchronized (object) {
            return super.toArray(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        Object object = this.mutex;
        synchronized (object) {
            return super.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SynchronizedListenableIterator
    implements Iterator<T> {
        final Iterator<T> it;

        public SynchronizedListenableIterator() {
            this.it = SynchronizedListenableCollection.super.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            Object object = SynchronizedListenableCollection.this.mutex;
            synchronized (object) {
                return this.it.hasNext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T next() {
            Object object = SynchronizedListenableCollection.this.mutex;
            synchronized (object) {
                return this.it.next();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            Object object = SynchronizedListenableCollection.this.mutex;
            synchronized (object) {
                this.it.remove();
            }
        }
    }
}

