/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.util;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public class NIOUtils {
    public static void put(Buffer input, ByteBuffer outputBytes) {
        if (input instanceof IntBuffer) {
            outputBytes.asIntBuffer().put((IntBuffer)input);
        } else if (input instanceof LongBuffer) {
            outputBytes.asLongBuffer().put((LongBuffer)input);
        } else if (input instanceof ShortBuffer) {
            outputBytes.asShortBuffer().put((ShortBuffer)input);
        } else if (input instanceof CharBuffer) {
            outputBytes.asCharBuffer().put((CharBuffer)input);
        } else if (input instanceof DoubleBuffer) {
            outputBytes.asDoubleBuffer().put((DoubleBuffer)input);
        } else if (input instanceof FloatBuffer) {
            outputBytes.asFloatBuffer().put((FloatBuffer)input);
        } else {
            throw new UnsupportedOperationException("Unhandled buffer type : " + input.getClass().getName());
        }
        outputBytes.rewind();
    }

    public static void put(ByteBuffer inputBytes, Buffer output) {
        if (output instanceof IntBuffer) {
            ((IntBuffer)output).put(inputBytes.asIntBuffer());
        } else if (output instanceof LongBuffer) {
            ((LongBuffer)output).put(inputBytes.asLongBuffer());
        } else if (output instanceof ShortBuffer) {
            ((ShortBuffer)output).put(inputBytes.asShortBuffer());
        } else if (output instanceof CharBuffer) {
            ((CharBuffer)output).put(inputBytes.asCharBuffer());
        } else if (output instanceof DoubleBuffer) {
            ((DoubleBuffer)output).put(inputBytes.asDoubleBuffer());
        } else if (output instanceof FloatBuffer) {
            ((FloatBuffer)output).put(inputBytes.asFloatBuffer());
        } else {
            throw new UnsupportedOperationException("Unhandled buffer type : " + output.getClass().getName());
        }
        output.rewind();
    }

    public static IntBuffer directCopy(IntBuffer b, ByteOrder order) {
        return NIOUtils.directCopy((Buffer)b, order).asIntBuffer();
    }

    public static LongBuffer directCopy(LongBuffer b, ByteOrder order) {
        return NIOUtils.directCopy((Buffer)b, order).asLongBuffer();
    }

    public static ShortBuffer directCopy(ShortBuffer b, ByteOrder order) {
        return NIOUtils.directCopy((Buffer)b, order).asShortBuffer();
    }

    public static CharBuffer directCopy(CharBuffer b, ByteOrder order) {
        return NIOUtils.directCopy((Buffer)b, order).asCharBuffer();
    }

    public static DoubleBuffer directCopy(DoubleBuffer b, ByteOrder order) {
        return NIOUtils.directCopy((Buffer)b, order).asDoubleBuffer();
    }

    public static FloatBuffer directCopy(FloatBuffer b, ByteOrder order) {
        return NIOUtils.directCopy((Buffer)b, order).asFloatBuffer();
    }

    public static ByteBuffer directCopy(Buffer b, ByteOrder order) {
        ByteBuffer copy = ByteBuffer.allocateDirect((int)NIOUtils.getSizeInBytes(b)).order(order == null ? ByteOrder.nativeOrder() : order);
        NIOUtils.put(b, copy);
        return copy;
    }

    public static IntBuffer directInts(int size, ByteOrder order) {
        return ByteBuffer.allocateDirect(size * 4).order(order == null ? ByteOrder.nativeOrder() : order).asIntBuffer();
    }

    public static LongBuffer directLongs(int size, ByteOrder order) {
        return ByteBuffer.allocateDirect(size * 8).order(order == null ? ByteOrder.nativeOrder() : order).asLongBuffer();
    }

    public static ShortBuffer directShorts(int size, ByteOrder order) {
        return ByteBuffer.allocateDirect(size * 2).order(order == null ? ByteOrder.nativeOrder() : order).asShortBuffer();
    }

    public static ByteBuffer directBytes(int size, ByteOrder order) {
        return ByteBuffer.allocateDirect(size).order(order == null ? ByteOrder.nativeOrder() : order);
    }

    public static FloatBuffer directFloats(int size, ByteOrder order) {
        return ByteBuffer.allocateDirect(size * 4).order(order == null ? ByteOrder.nativeOrder() : order).asFloatBuffer();
    }

    public static DoubleBuffer directDoubles(int size, ByteOrder order) {
        return ByteBuffer.allocateDirect(size * 8).order(order == null ? ByteOrder.nativeOrder() : order).asDoubleBuffer();
    }

    public static <B extends Buffer> B directBuffer(int size, ByteOrder order, Class<B> bufferClass) {
        if (IntBuffer.class.isAssignableFrom(bufferClass)) {
            return (B)NIOUtils.directInts(size, order);
        }
        if (LongBuffer.class.isAssignableFrom(bufferClass)) {
            return (B)NIOUtils.directLongs(size, order);
        }
        if (ShortBuffer.class.isAssignableFrom(bufferClass)) {
            return (B)NIOUtils.directShorts(size, order);
        }
        if (ByteBuffer.class.isAssignableFrom(bufferClass)) {
            return (B)NIOUtils.directBytes(size, order);
        }
        if (DoubleBuffer.class.isAssignableFrom(bufferClass)) {
            return (B)NIOUtils.directDoubles(size, order);
        }
        if (FloatBuffer.class.isAssignableFrom(bufferClass)) {
            return (B)NIOUtils.directFloats(size, order);
        }
        throw new UnsupportedOperationException("Cannot create direct buffers of type " + bufferClass.getName());
    }

    public static long getSizeInBytes(Buffer b) {
        int c = b.capacity();
        return NIOUtils.getComponentSizeInBytes(b) * c;
    }

    public static int getComponentSizeInBytes(Buffer b) {
        if (b instanceof IntBuffer || b instanceof FloatBuffer) {
            return 4;
        }
        if (b instanceof LongBuffer || b instanceof DoubleBuffer) {
            return 8;
        }
        if (b instanceof ShortBuffer || b instanceof CharBuffer) {
            return 2;
        }
        if (b instanceof ByteBuffer) {
            return 1;
        }
        throw new UnsupportedOperationException("Cannot guess byte size of buffers of type " + b.getClass().getName());
    }

    public static <B extends Buffer, V> void put(B buffer, int position, V value) {
        if (buffer instanceof IntBuffer) {
            ((IntBuffer)buffer).put(position, ((Number)value).intValue());
        } else if (buffer instanceof LongBuffer) {
            ((LongBuffer)buffer).put(position, ((Number)value).longValue());
        } else if (buffer instanceof ShortBuffer) {
            ((ShortBuffer)buffer).put(position, ((Number)value).shortValue());
        } else if (buffer instanceof ByteBuffer) {
            ((ByteBuffer)buffer).put(position, ((Number)value).byteValue());
        } else if (buffer instanceof DoubleBuffer) {
            ((DoubleBuffer)buffer).put(position, ((Number)value).doubleValue());
        } else if (buffer instanceof FloatBuffer) {
            ((FloatBuffer)buffer).put(position, ((Number)value).floatValue());
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public static <B extends Buffer, V> V get(B buffer, int position) {
        if (buffer instanceof IntBuffer) {
            return (V)Integer.valueOf(((IntBuffer)buffer).get(position));
        }
        if (buffer instanceof LongBuffer) {
            return (V)Long.valueOf(((LongBuffer)buffer).get(position));
        }
        if (buffer instanceof ShortBuffer) {
            return (V)Short.valueOf(((ShortBuffer)buffer).get(position));
        }
        if (buffer instanceof ByteBuffer) {
            return (V)Byte.valueOf(((ByteBuffer)buffer).get(position));
        }
        if (buffer instanceof DoubleBuffer) {
            return (V)Double.valueOf(((DoubleBuffer)buffer).get(position));
        }
        if (buffer instanceof FloatBuffer) {
            return (V)Float.valueOf(((FloatBuffer)buffer).get(position));
        }
        throw new UnsupportedOperationException();
    }
}

