/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.runtime.jna;

import com.nativelibs4java.runtime.jna.StructIO;
import com.nativelibs4java.runtime.jna.StructWithNIO;
import java.nio.ByteBuffer;

public class StructIOWithNIO<S extends StructWithNIO<S>>
extends StructIO<S> {
    public StructIOWithNIO(Class<S> structClass) {
        super(structClass);
    }

    @Override
    public int getIntField(int fieldIndex, S struct) {
        if (((StructWithNIO)struct).isDirect()) {
            return super.getIntField(fieldIndex, struct);
        }
        StructIO.FieldIO field = this.fields[fieldIndex];
        if (field.isBitField) {
            throw new UnsupportedOperationException("Indirect Buffer-backed bit fields are not supported yet");
        }
        return ((ByteBuffer)((StructWithNIO)struct).getBuffer().duplicate().position(field.byteOffset)).asIntBuffer().get();
    }

    @Override
    public void setIntField(int fieldIndex, S struct, int value) {
        if (((StructWithNIO)struct).isDirect()) {
            super.setIntField(fieldIndex, struct, value);
            return;
        }
        StructIO.FieldIO field = this.fields[fieldIndex];
        if (field.isBitField) {
            throw new UnsupportedOperationException("Indirect Buffer-backed bit fields are not supported yet");
        }
        ((ByteBuffer)((StructWithNIO)struct).getBuffer().duplicate().position(field.byteOffset)).asIntBuffer().put(value);
    }
}

