/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.CLBuffer;
import com.nativelibs4java.opencl.CLBuildException;
import com.nativelibs4java.opencl.CLContext;
import com.nativelibs4java.opencl.CLEvent;
import com.nativelibs4java.opencl.CLKernel;
import com.nativelibs4java.opencl.CLMem;
import com.nativelibs4java.opencl.CLProgram;
import com.nativelibs4java.opencl.CLQueue;
import com.nativelibs4java.util.IOUtils;
import com.nativelibs4java.util.NIOUtils;
import com.ochafik.util.listenable.Pair;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReductionUtils {
    static String source;
    static final String sourcePath;
    private static final int[] UNIT_INT_ARRAY;

    static synchronized String getSource() throws IOException {
        InputStream in = ReductionUtils.class.getClassLoader().getResourceAsStream(sourcePath);
        if (in == null) {
            throw new FileNotFoundException(sourcePath);
        }
        source = IOUtils.readText(in);
        return source;
    }

    public static Pair<String, Map<String, Object>> getReductionCodeAndMacros(Operation op, Type valueType, int channels) throws IOException {
        String seed;
        String operation;
        LinkedHashMap<String, String> macros = new LinkedHashMap<String, String>();
        String cType = valueType.toCType() + (channels == 1 ? "" : Integer.valueOf(channels));
        macros.put("OPERAND_TYPE", cType);
        block0 : switch (op) {
            case Add: {
                operation = "_add_";
                seed = "0";
                break;
            }
            case Multiply: {
                operation = "_mul_";
                seed = "1";
                break;
            }
            case Min: {
                operation = "_min_";
                switch (valueType) {
                    case Int: {
                        seed = "2147483647";
                        break block0;
                    }
                    case Long: {
                        seed = "9223372036854775807LL";
                        break block0;
                    }
                    case Short: {
                        seed = "32767";
                        break block0;
                    }
                    case Float: {
                        seed = "MAXFLOAT";
                        break block0;
                    }
                    case Double: {
                        seed = "MAXDOUBLE";
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Unhandled seed type: " + (Object)((Object)valueType));
            }
            case Max: {
                operation = "_max_";
                switch (valueType) {
                    case Int: {
                        seed = "-2147483648";
                        break block0;
                    }
                    case Long: {
                        seed = "-9223372036854775808LL";
                        break block0;
                    }
                    case Short: {
                        seed = "-32768";
                        break block0;
                    }
                    case Float: {
                        seed = "-MAXFLOAT";
                        break block0;
                    }
                    case Double: {
                        seed = "-MAXDOUBLE";
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Unhandled seed type: " + (Object)((Object)valueType));
            }
            default: {
                throw new IllegalArgumentException("Unhandled operation: " + (Object)((Object)op));
            }
        }
        macros.put("OPERATION", operation);
        macros.put("SEED", seed);
        return new Pair<String, Map<String, Object>>(ReductionUtils.getSource(), macros);
    }

    static int getNextPowerOfTwo(int i) {
        int shifted = 0;
        boolean lost = false;
        while (true) {
            int next;
            if ((next = i >> 1) == 0) {
                if (lost) {
                    return 1 << shifted + 1;
                }
                return 1 << shifted;
            }
            lost = lost || next << 1 != i;
            ++shifted;
            i = next;
        }
    }

    public static <B extends Buffer> Reductor<B> createReductor(final CLContext context, Operation op, Type valueType, final int valueChannels) throws CLBuildException {
        try {
            Pair<String, Map<String, Object>> codeAndMacros = ReductionUtils.getReductionCodeAndMacros(op, valueType, valueChannels);
            CLProgram program = context.createProgram(codeAndMacros.getFirst());
            program.defineMacros(codeAndMacros.getValue());
            program.build();
            CLKernel[] kernels = program.createKernels();
            if (kernels.length != 1) {
                throw new RuntimeException("Expected 1 kernel, found : " + kernels.length);
            }
            final CLKernel kernel = kernels[0];
            return new Reductor<B>(){

                @Override
                public CLEvent reduce(CLQueue queue, CLBuffer<B> input, long inputLength, B output, int maxReductionSize, CLEvent ... eventsToWaitFor) {
                    Pair outAndEvts = this.reduceHelper(queue, input, (int)inputLength, output.getClass(), maxReductionSize, eventsToWaitFor);
                    return outAndEvts.getFirst().read(queue, 0L, (long)valueChannels, output, false, outAndEvts.getSecond());
                }

                @Override
                public B reduce(CLQueue queue, CLBuffer<B> input, long inputLength, int maxReductionSize, CLEvent ... eventsToWaitFor) {
                    Object output = NIOUtils.directBuffer((int)inputLength, context.getByteOrder(), input.typedBufferClass());
                    CLEvent evt = this.reduce(queue, input, inputLength, output, maxReductionSize, eventsToWaitFor);
                    evt.waitFor();
                    return output;
                }

                @Override
                public CLEvent reduce(CLQueue queue, CLBuffer<B> input, long inputLength, CLBuffer<B> output, int maxReductionSize, CLEvent ... eventsToWaitFor) {
                    Pair outAndEvts = this.reduceHelper(queue, input, (int)inputLength, output.typedBufferClass(), maxReductionSize, eventsToWaitFor);
                    return outAndEvts.getFirst().copyTo(queue, 0L, valueChannels, output, 0L, outAndEvts.getSecond());
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Pair<CLBuffer<B>, CLEvent[]> reduceHelper(CLQueue queue, CLBuffer<B> input, int inputLength, Class<B> outputClass, int maxReductionSize, CLEvent ... eventsToWaitFor) {
                    CLBuffer[] tempBuffers = new CLBuffer[2];
                    int depth = 0;
                    CLBuffer currentOutput = null;
                    CLEvent[] eventsArr = new CLEvent[1];
                    int[] inputLengthArr = new int[1];
                    int maxWIS = (int)queue.getDevice().getMaxWorkItemSizes()[0];
                    while (inputLength > 1) {
                        int nInCurrentDepth = inputLength / maxReductionSize;
                        if (inputLength > nInCurrentDepth * maxReductionSize) {
                            ++nInCurrentDepth;
                        }
                        int iOutput = depth & 1;
                        CLBuffer currentInput = depth == 0 ? input : tempBuffers[iOutput ^ 1];
                        currentOutput = tempBuffers[iOutput];
                        if (currentOutput == null) {
                            currentOutput = tempBuffers[iOutput] = context.createBuffer(CLMem.Usage.InputOutput, maxReductionSize * valueChannels, outputClass);
                        }
                        CLKernel cLKernel = kernel;
                        synchronized (cLKernel) {
                            kernel.setArgs(currentInput, inputLength, maxReductionSize, currentOutput);
                            inputLengthArr[0] = inputLength;
                            int wis = (inputLength & 1) == 0 && maxWIS > 1 ? 2 : 1;
                            eventsArr[0] = kernel.enqueueNDRange(queue, inputLengthArr, new int[]{wis}, eventsToWaitFor);
                        }
                        eventsToWaitFor = eventsArr;
                        inputLength = nInCurrentDepth;
                        ++depth;
                    }
                    return new Pair<Object, CLEvent[]>(currentOutput, eventsToWaitFor);
                }
            };
        }
        catch (IOException ex) {
            Logger.getLogger(ReductionUtils.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException("Failed to create a " + (Object)((Object)op) + " reductor for type " + (Object)((Object)valueType) + valueChannels, ex);
        }
    }

    static {
        sourcePath = ReductionUtils.class.getPackage().getName().replace('.', '/') + "/" + "Reduction.c";
        UNIT_INT_ARRAY = new int[]{1};
    }

    public static interface Reductor<B extends Buffer> {
        public CLEvent reduce(CLQueue var1, CLBuffer<B> var2, long var3, B var5, int var6, CLEvent ... var7);

        public B reduce(CLQueue var1, CLBuffer<B> var2, long var3, int var5, CLEvent ... var6);

        public CLEvent reduce(CLQueue var1, CLBuffer<B> var2, long var3, CLBuffer<B> var5, int var6, CLEvent ... var7);
    }

    public static enum Type {
        Int,
        Long,
        Short,
        Byte,
        Double,
        Float,
        Half;


        public String toCType() {
            if (this == Byte) {
                return "char";
            }
            return this.name().toLowerCase();
        }

        public static Type fromClass(Class<? extends Number> valueType) {
            if (!valueType.isPrimitive()) {
                throw new IllegalArgumentException("Reduction value type is not a primitive: '" + valueType.getName() + "' !");
            }
            if (valueType == Integer.TYPE) {
                return Int;
            }
            if (valueType == java.lang.Long.TYPE) {
                return Long;
            }
            if (valueType == java.lang.Short.TYPE) {
                return Short;
            }
            if (valueType == java.lang.Double.TYPE) {
                return Double;
            }
            if (valueType == java.lang.Float.TYPE) {
                return Float;
            }
            if (valueType == java.lang.Byte.TYPE) {
                return Byte;
            }
            throw new IllegalArgumentException("Primitive type not handled: '" + valueType.getName() + "' !");
        }
    }

    public static enum Operation {
        Add,
        Multiply,
        Min,
        Max;

    }
}

