/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.CLContext;
import com.nativelibs4java.opencl.CLDevice;
import com.nativelibs4java.opencl.CLException;
import com.nativelibs4java.opencl.CLPlatform;
import com.nativelibs4java.opencl.library.OpenCLLibrary;
import com.sun.jna.ptr.IntByReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class JavaCL {
    static final OpenCLLibrary CL = OpenCLLibrary.INSTANCE;

    public static CLPlatform[] listGPUPoweredPlatforms() {
        CLPlatform[] platforms = JavaCL.listPlatforms();
        ArrayList<CLPlatform> out = new ArrayList<CLPlatform>(platforms.length);
        for (CLPlatform platform : platforms) {
            if (platform.listGPUDevices(true).length <= 0) continue;
            out.add(platform);
        }
        return out.toArray(new CLPlatform[out.size()]);
    }

    public static CLPlatform[] listPlatforms() {
        IntByReference pCount = new IntByReference();
        CLException.error(CL.clGetPlatformIDs(0, (OpenCLLibrary.cl_platform_id[])null, pCount));
        int nPlats = pCount.getValue();
        if (nPlats == 0) {
            return new CLPlatform[0];
        }
        OpenCLLibrary.cl_platform_id[] ids = new OpenCLLibrary.cl_platform_id[nPlats];
        CLException.error(CL.clGetPlatformIDs(nPlats, ids, null));
        CLPlatform[] platforms = new CLPlatform[nPlats];
        for (int i = 0; i < nPlats; ++i) {
            platforms[i] = new CLPlatform(ids[i]);
        }
        return platforms;
    }

    public static CLContext createContext(Map<CLPlatform.ContextProperties, Number> contextProperties, CLDevice ... devices) {
        return devices[0].getPlatform().createContext(contextProperties, devices);
    }

    public static void unloadCompiler() {
        CLException.error(CL.clUnloadCompiler());
    }

    public static CLDevice getBestDevice() {
        ArrayList<CLDevice> devices = new ArrayList<CLDevice>();
        for (CLPlatform platform : JavaCL.listPlatforms()) {
            devices.addAll(Arrays.asList(platform.listAllDevices(true)));
        }
        return CLPlatform.getBestDevice(CLPlatform.DeviceEvaluationStrategy.BiggestMaxComputeUnits, devices);
    }

    public static CLContext createBestContext() {
        CLDevice device = JavaCL.getBestDevice();
        return device.getPlatform().createContext(null, device);
    }

    public static CLContext createContextFromCurrentGL() {
        RuntimeException first = null;
        for (CLPlatform platform : JavaCL.listPlatforms()) {
            try {
                CLContext ctx = platform.createContextFromCurrentGL();
                if (ctx == null) continue;
                return ctx;
            }
            catch (RuntimeException ex) {
                if (first != null) continue;
                first = ex;
            }
        }
        throw new RuntimeException("Failed to create an OpenCL context based on the current OpenGL context", first);
    }
}

