/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.CLAbstractEntity;
import com.nativelibs4java.opencl.CLException;
import com.nativelibs4java.opencl.CLInfoGetter;
import com.nativelibs4java.opencl.CLQueue;
import com.nativelibs4java.opencl.InfoName;
import com.nativelibs4java.opencl.JavaCL;
import com.nativelibs4java.opencl.library.OpenCLLibrary;
import com.nativelibs4java.util.EnumValues;
import com.ochafik.lang.jnaerator.runtime.NativeSize;
import com.ochafik.lang.jnaerator.runtime.NativeSizeByReference;
import com.sun.jna.Pointer;
import java.util.Arrays;

public class CLEvent
extends CLAbstractEntity<OpenCLLibrary.cl_event> {
    private static CLInfoGetter<OpenCLLibrary.cl_event> infos = new CLInfoGetter<OpenCLLibrary.cl_event>(){

        @Override
        protected int getInfo(OpenCLLibrary.cl_event entity, int infoTypeEnum, NativeSize size, Pointer out, NativeSizeByReference sizeOut) {
            return JavaCL.CL.clGetEventInfo(entity, infoTypeEnum, size, out, sizeOut);
        }
    };
    private static CLInfoGetter<OpenCLLibrary.cl_event> profilingInfos = new CLInfoGetter<OpenCLLibrary.cl_event>(){

        @Override
        protected int getInfo(OpenCLLibrary.cl_event entity, int infoTypeEnum, NativeSize size, Pointer out, NativeSizeByReference sizeOut) {
            return JavaCL.CL.clGetEventProfilingInfo(entity, infoTypeEnum, size, out, sizeOut);
        }
    };
    static boolean noEvents = false;

    private CLEvent(OpenCLLibrary.cl_event evt) {
        super(evt, false);
    }

    private CLEvent() {
        super(null, true);
    }

    public static void setNoEvents(boolean noEvents) {
        CLEvent.noEvents = noEvents;
    }

    static CLEvent createEvent(final CLQueue queue, OpenCLLibrary.cl_event evt) {
        if (noEvents) {
            if (evt != null) {
                JavaCL.CL.clReleaseEvent(evt);
            }
            evt = null;
            return new CLEvent(){
                volatile boolean waited;
                {
                    this.waited = false;
                }

                @Override
                public synchronized void waitFor() {
                    if (!this.waited) {
                        queue.finish();
                        this.waited = true;
                    }
                }
            };
        }
        if (evt == null) {
            return null;
        }
        return new CLEvent(evt);
    }

    static CLEvent createEvent(CLQueue queue, OpenCLLibrary.cl_event[] evt1) {
        if (evt1 == null) {
            return null;
        }
        return CLEvent.createEvent(queue, evt1[0]);
    }

    public void waitFor() {
        CLEvent.waitFor(this);
        this.release();
    }

    public static void waitFor(CLEvent ... eventsToWaitFor) {
        if (eventsToWaitFor.length == 0) {
            return;
        }
        try {
            OpenCLLibrary.cl_event[] evts = CLEvent.to_cl_event_array(eventsToWaitFor);
            if (evts == null || evts.length == 0) {
                return;
            }
            CLException.error(JavaCL.CL.clWaitForEvents(evts.length, evts));
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception while waiting for events " + Arrays.asList(eventsToWaitFor), ex);
        }
    }

    public void invokeUponCompletion(Runnable action) {
        CLEvent.invokeUponCompletion(action, this);
    }

    public static void invokeUponCompletion(final Runnable action, final CLEvent ... eventsToWaitFor) {
        if (action == null) {
            throw new IllegalArgumentException("Null action !");
        }
        new Thread(){

            @Override
            public void run() {
                CLEvent.waitFor(eventsToWaitFor);
                action.run();
            }
        }.start();
    }

    static OpenCLLibrary.cl_event[] new_event_out(CLEvent[] eventsToWaitFor) {
        return noEvents || eventsToWaitFor == null ? null : new OpenCLLibrary.cl_event[1];
    }

    static OpenCLLibrary.cl_event[] to_cl_event_array(CLEvent ... events) {
        if (noEvents) {
            for (CLEvent evt : events) {
                if (evt == null) continue;
                evt.waitFor();
            }
            return null;
        }
        int n = events.length;
        if (n == 0) {
            return null;
        }
        int nonNulls = 0;
        for (int i = 0; i < n; ++i) {
            if (events[i] == null || events[i].getEntity() == null) continue;
            ++nonNulls;
        }
        if (nonNulls == 0) {
            return null;
        }
        OpenCLLibrary.cl_event[] event_wait_list = new OpenCLLibrary.cl_event[nonNulls];
        int iDest = 0;
        for (int i = 0; i < n; ++i) {
            CLEvent event = events[i];
            if (event == null || event.getEntity() == null) continue;
            event_wait_list[iDest] = (OpenCLLibrary.cl_event)event.getEntity();
        }
        return event_wait_list;
    }

    @Override
    protected void clear() {
        CLException.error(JavaCL.CL.clReleaseEvent((OpenCLLibrary.cl_event)this.getEntity()));
    }

    @InfoName(value="CL_EVENT_COMMAND_EXECUTION_STATUS")
    public CommandExecutionStatus getCommandExecutionStatus() {
        int v = infos.getInt((OpenCLLibrary.cl_event)this.getEntity(), 4563);
        CommandExecutionStatus status = CommandExecutionStatus.getEnum(v);
        if (status == null) {
            CLException.error(v);
        }
        return status;
    }

    @InfoName(value="CL_EVENT_COMMAND_TYPE")
    public CommandType getCommandType() {
        return CommandType.getEnum(infos.getInt((OpenCLLibrary.cl_event)this.getEntity(), 4561));
    }

    @InfoName(value="CL_CL_PROFILING_COMMAND_QUEUED")
    public long getProfilingCommandQueued() {
        return profilingInfos.getIntOrLong((OpenCLLibrary.cl_event)this.getEntity(), 4736);
    }

    @InfoName(value="CL_CL_PROFILING_COMMAND_SUBMIT")
    public long getProfilingCommandSubmit() {
        return profilingInfos.getIntOrLong((OpenCLLibrary.cl_event)this.getEntity(), 4737);
    }

    @InfoName(value="CL_CL_PROFILING_COMMAND_START")
    public long getProfilingCommandStart() {
        return profilingInfos.getIntOrLong((OpenCLLibrary.cl_event)this.getEntity(), 4738);
    }

    @InfoName(value="CL_CL_PROFILING_COMMAND_END")
    public long getProfilingCommandEnd() {
        return profilingInfos.getIntOrLong((OpenCLLibrary.cl_event)this.getEntity(), 4739);
    }

    public String toString() {
        return "Event {commandType: " + (Object)((Object)this.getCommandType()) + "}";
    }

    public static enum CommandType {
        NDRangeKernel,
        Task,
        NativeKernel,
        ReadBuffer,
        WriteBuffer,
        CopyBuffer,
        ReadImage,
        WriteImage,
        CopyImage,
        CopyBufferToImage,
        CopyImageToBuffer,
        MapBuffer,
        CommandMapImage,
        UnmapMemObject,
        Marker,
        AcquireGLObjects,
        ReleaseGLObjects;


        public long getValue() {
            return EnumValues.getValue(this);
        }

        public static CommandType getEnum(long v) {
            return EnumValues.getEnum(v, CommandType.class);
        }
    }

    public static enum CommandExecutionStatus {
        Queued,
        Submitted,
        Running,
        Complete;


        public long getValue() {
            return EnumValues.getValue(this);
        }

        public static CommandExecutionStatus getEnum(long v) {
            return EnumValues.getEnum(v, CommandExecutionStatus.class);
        }
    }
}

