/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.CLByteBuffer;
import com.nativelibs4java.opencl.CLCharBuffer;
import com.nativelibs4java.opencl.CLContext;
import com.nativelibs4java.opencl.CLDoubleBuffer;
import com.nativelibs4java.opencl.CLEvent;
import com.nativelibs4java.opencl.CLException;
import com.nativelibs4java.opencl.CLFloatBuffer;
import com.nativelibs4java.opencl.CLIntBuffer;
import com.nativelibs4java.opencl.CLLongBuffer;
import com.nativelibs4java.opencl.CLMem;
import com.nativelibs4java.opencl.CLQueue;
import com.nativelibs4java.opencl.CLShortBuffer;
import com.nativelibs4java.opencl.JavaCL;
import com.nativelibs4java.opencl.library.OpenCLLibrary;
import com.nativelibs4java.util.JNAUtils;
import com.nativelibs4java.util.NIOUtils;
import com.ochafik.util.listenable.Pair;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public abstract class CLBuffer<B extends Buffer>
extends CLMem {
    Buffer buffer;
    final int elementSize;

    CLBuffer(CLContext context, long byteCount, OpenCLLibrary.cl_mem entity, Buffer buffer, int elementSize) {
        super(context, byteCount, entity);
        this.buffer = buffer;
        this.elementSize = elementSize;
    }

    public int getElementSize() {
        return this.elementSize;
    }

    public long getElementCount() {
        return this.getByteCount() / (long)this.getElementSize();
    }

    public B map(CLQueue queue, CLMem.MapFlags flags, CLEvent ... eventsToWaitFor) throws CLException.MapFailure {
        return (B)((Buffer)this.map(queue, flags, 0L, this.getElementCount(), true, eventsToWaitFor).getFirst());
    }

    public B map(CLQueue queue, CLMem.MapFlags flags, long offset, long length, CLEvent ... eventsToWaitFor) throws CLException.MapFailure {
        return (B)((Buffer)this.map(queue, flags, offset, length, true, eventsToWaitFor).getFirst());
    }

    public Pair<B, CLEvent> mapLater(CLQueue queue, CLMem.MapFlags flags, CLEvent ... eventsToWaitFor) throws CLException.MapFailure {
        return this.map(queue, flags, 0L, this.getElementCount(), false, eventsToWaitFor);
    }

    public Pair<B, CLEvent> mapLater(CLQueue queue, CLMem.MapFlags flags, long offset, long length, CLEvent ... eventsToWaitFor) throws CLException.MapFailure {
        return this.map(queue, flags, offset, length, false, eventsToWaitFor);
    }

    public B read(CLQueue queue, CLEvent ... eventsToWaitFor) {
        B out = this.typedBuffer(NIOUtils.directBytes((int)this.getByteCount(), queue.getDevice().getKernelsDefaultByteOrder()));
        this.read(queue, out, true, eventsToWaitFor);
        return out;
    }

    public B read(CLQueue queue, long offset, long length, CLEvent ... eventsToWaitFor) {
        B out = this.typedBuffer(NIOUtils.directBytes((int)this.getByteCount(), queue.getDevice().getKernelsDefaultByteOrder()));
        this.read(queue, offset, length, out, true, eventsToWaitFor);
        return out;
    }

    protected void checkBounds(long offset, long length) {
        if (offset + length * (long)this.getElementSize() > this.getByteCount()) {
            throw new IndexOutOfBoundsException("Trying to map a region of memory object outside allocated range");
        }
    }

    public CLEvent copyTo(CLQueue queue, long srcOffset, long length, CLMem destination, long destOffset, CLEvent ... eventsToWaitFor) {
        OpenCLLibrary.cl_event[] eventOut = CLEvent.new_event_out(eventsToWaitFor);
        OpenCLLibrary.cl_event[] evts = CLEvent.to_cl_event_array(eventsToWaitFor);
        CLException.error(JavaCL.CL.clEnqueueCopyBuffer((OpenCLLibrary.cl_command_queue)queue.getEntity(), (OpenCLLibrary.cl_mem)this.getEntity(), (OpenCLLibrary.cl_mem)destination.getEntity(), JNAUtils.toNS(srcOffset * (long)this.getElementSize()), JNAUtils.toNS(destOffset * (long)this.getElementSize()), JNAUtils.toNS(length), evts == null ? 0 : evts.length, evts, eventOut));
        return CLEvent.createEvent(queue, eventOut);
    }

    protected Pair<B, CLEvent> map(CLQueue queue, CLMem.MapFlags flags, long offset, long length, boolean blocking, CLEvent ... eventsToWaitFor) {
        this.checkBounds(offset, length);
        OpenCLLibrary.cl_event[] eventOut = blocking ? null : CLEvent.new_event_out(eventsToWaitFor);
        IntByReference pErr = new IntByReference();
        OpenCLLibrary.cl_event[] evts = CLEvent.to_cl_event_array(eventsToWaitFor);
        Pointer p = JavaCL.CL.clEnqueueMapBuffer((OpenCLLibrary.cl_command_queue)queue.getEntity(), (OpenCLLibrary.cl_mem)this.getEntity(), blocking ? 1 : 0, flags.getValue(), JNAUtils.toNS(offset * (long)this.getElementSize()), JNAUtils.toNS(length * (long)this.getElementSize()), evts == null ? 0 : evts.length, evts, eventOut, pErr);
        CLException.error(pErr.getValue());
        return new Pair<B, CLEvent>(this.typedBuffer(p.getByteBuffer(0L, this.getByteCount()).order(queue.getDevice().getKernelsDefaultByteOrder())), CLEvent.createEvent(queue, eventOut));
    }

    protected abstract B typedBuffer(ByteBuffer var1);

    protected abstract Class<B> typedBufferClass();

    protected abstract void put(B var1, B var2);

    public CLEvent unmap(CLQueue queue, B buffer, CLEvent ... eventsToWaitFor) {
        OpenCLLibrary.cl_event[] eventOut = CLEvent.new_event_out(eventsToWaitFor);
        OpenCLLibrary.cl_event[] evts = CLEvent.to_cl_event_array(eventsToWaitFor);
        CLException.error(JavaCL.CL.clEnqueueUnmapMemObject((OpenCLLibrary.cl_command_queue)queue.getEntity(), (OpenCLLibrary.cl_mem)this.getEntity(), Native.getDirectBufferPointer(buffer), evts == null ? 0 : evts.length, evts, eventOut));
        return CLEvent.createEvent(queue, eventOut);
    }

    public CLEvent read(CLQueue queue, B out, boolean blocking, CLEvent ... eventsToWaitFor) {
        long length;
        if (this.isGL) {
            length = ((Buffer)out).capacity();
        } else {
            long s;
            length = this.getElementCount();
            if (length > (s = (long)((Buffer)out).capacity())) {
                length = s;
            }
        }
        return this.read(queue, 0L, length, out, blocking, eventsToWaitFor);
    }

    public CLEvent read(CLQueue queue, long offset, long length, B out, boolean blocking, CLEvent ... eventsToWaitFor) {
        B originalOut = null;
        if (!((Buffer)out).isDirect()) {
            originalOut = out;
            out = this.typedBuffer(NIOUtils.directBytes((int)(length * (long)this.getElementSize()), queue.getDevice().getKernelsDefaultByteOrder()));
            blocking = true;
        }
        OpenCLLibrary.cl_event[] eventOut = blocking ? null : CLEvent.new_event_out(eventsToWaitFor);
        OpenCLLibrary.cl_event[] evts = CLEvent.to_cl_event_array(eventsToWaitFor);
        CLException.error(JavaCL.CL.clEnqueueReadBuffer((OpenCLLibrary.cl_command_queue)queue.getEntity(), (OpenCLLibrary.cl_mem)this.getEntity(), blocking ? 1 : 0, JNAUtils.toNS(offset * (long)this.getElementSize()), JNAUtils.toNS(length * (long)this.getElementSize()), Native.getDirectBufferPointer(out), evts == null ? 0 : evts.length, evts, eventOut));
        if (originalOut != null) {
            this.put(out, originalOut);
        }
        return CLEvent.createEvent(queue, eventOut);
    }

    public CLEvent write(CLQueue queue, B in, boolean blocking, CLEvent ... eventsToWaitFor) {
        long length;
        if (this.isGL) {
            length = ((Buffer)in).capacity();
        } else {
            long s;
            length = this.getElementCount();
            if (length > (s = (long)((Buffer)in).capacity())) {
                length = s;
            }
        }
        return this.write(queue, 0L, length, in, blocking, eventsToWaitFor);
    }

    public CLEvent write(CLQueue queue, long offset, long length, B in, boolean blocking, CLEvent ... eventsToWaitFor) {
        if (!((Buffer)in).isDirect()) {
            blocking = true;
            in = this.typedBuffer(NIOUtils.directCopy(in, queue.getDevice().getKernelsDefaultByteOrder()));
        }
        OpenCLLibrary.cl_event[] eventOut = blocking ? null : CLEvent.new_event_out(eventsToWaitFor);
        OpenCLLibrary.cl_event[] evts = CLEvent.to_cl_event_array(eventsToWaitFor);
        CLException.error(JavaCL.CL.clEnqueueWriteBuffer((OpenCLLibrary.cl_command_queue)queue.getEntity(), (OpenCLLibrary.cl_mem)this.getEntity(), blocking ? 1 : 0, JNAUtils.toNS(offset * (long)this.getElementSize()), JNAUtils.toNS(length * (long)this.getElementSize()), Native.getDirectBufferPointer(in), evts == null ? 0 : evts.length, evts, eventOut));
        return CLEvent.createEvent(queue, eventOut);
    }

    public CLEvent writeBytes(CLQueue queue, long offset, long length, ByteBuffer in, boolean blocking, CLEvent ... eventsToWaitFor) {
        if (!in.isDirect()) {
            blocking = true;
            in = NIOUtils.directCopy(in, queue.getDevice().getKernelsDefaultByteOrder());
        }
        OpenCLLibrary.cl_event[] eventOut = blocking ? null : CLEvent.new_event_out(eventsToWaitFor);
        OpenCLLibrary.cl_event[] evts = CLEvent.to_cl_event_array(eventsToWaitFor);
        CLException.error(JavaCL.CL.clEnqueueWriteBuffer((OpenCLLibrary.cl_command_queue)queue.getEntity(), (OpenCLLibrary.cl_mem)this.getEntity(), blocking ? 1 : 0, JNAUtils.toNS(offset), JNAUtils.toNS(length), Native.getDirectBufferPointer(in), evts == null ? 0 : evts.length, evts, eventOut));
        return CLEvent.createEvent(queue, eventOut);
    }

    public ByteBuffer readBytes(CLQueue queue, long offset, long length, CLEvent ... eventsToWaitFor) {
        ByteBuffer out = NIOUtils.directBytes((int)this.getByteCount(), queue.getDevice().getKernelsDefaultByteOrder());
        B tout = this.typedBuffer(out);
        this.read(queue, offset, (long)((Buffer)tout).capacity(), tout, true, eventsToWaitFor);
        return out;
    }

    private <T extends CLMem> T copyGLMark(T mem) {
        mem.isGL = this.isGL;
        return mem;
    }

    public CLIntBuffer asCLIntBuffer() {
        OpenCLLibrary.cl_mem mem = (OpenCLLibrary.cl_mem)this.getEntity();
        JavaCL.CL.clRetainMemObject((OpenCLLibrary.cl_mem)this.getEntity());
        return this.copyGLMark(new CLIntBuffer(this.context, this.getByteCount(), mem, this.buffer));
    }

    public CLShortBuffer asCLShortBuffer() {
        OpenCLLibrary.cl_mem mem = (OpenCLLibrary.cl_mem)this.getEntity();
        JavaCL.CL.clRetainMemObject(mem);
        return this.copyGLMark(new CLShortBuffer(this.context, this.getByteCount(), mem, this.buffer));
    }

    public CLLongBuffer asCLLongBuffer() {
        OpenCLLibrary.cl_mem mem = (OpenCLLibrary.cl_mem)this.getEntity();
        JavaCL.CL.clRetainMemObject(mem);
        return this.copyGLMark(new CLLongBuffer(this.context, this.getByteCount(), mem, this.buffer));
    }

    public CLByteBuffer asCLByteBuffer() {
        OpenCLLibrary.cl_mem mem = (OpenCLLibrary.cl_mem)this.getEntity();
        JavaCL.CL.clRetainMemObject(mem);
        return this.copyGLMark(new CLByteBuffer(this.context, this.getByteCount(), mem, this.buffer));
    }

    public CLFloatBuffer asCLFloatBuffer() {
        OpenCLLibrary.cl_mem mem = (OpenCLLibrary.cl_mem)this.getEntity();
        JavaCL.CL.clRetainMemObject(mem);
        return this.copyGLMark(new CLFloatBuffer(this.context, this.getByteCount(), mem, this.buffer));
    }

    public CLDoubleBuffer asCLDoubleBuffer() {
        OpenCLLibrary.cl_mem mem = (OpenCLLibrary.cl_mem)this.getEntity();
        JavaCL.CL.clRetainMemObject(mem);
        return this.copyGLMark(new CLDoubleBuffer(this.context, this.getByteCount(), mem, this.buffer));
    }

    public CLCharBuffer asCLCharBuffer() {
        OpenCLLibrary.cl_mem mem = (OpenCLLibrary.cl_mem)this.getEntity();
        JavaCL.CL.clRetainMemObject(mem);
        return this.copyGLMark(new CLCharBuffer(this.context, this.getByteCount(), mem, this.buffer));
    }
}

