(ns clj-codapay.core
  (:require [clj-http.client :as client]
            [cheshire.core :as che])
  (:gen-class))

(defn init-item
  [code name price type]
  {:code code
   :name name
   :price (double (read-string price))
   :type type})

(defn init-request
  [api-key country currency item-coll pay-type order-id profile]
  {:initRequest
   {:apiKey api-key,
    :country (read-string country),
    :currency (read-string currency),
    :items item-coll,
    :payType (read-string pay-type),
    :orderId order-id,
    :profile profile}})

(defn init-request-post
  [init-api-url coda-init-request]
  (client/post init-api-url
               {:headers {}
                :content-type :json
                :accept :json
                :form-params coda-init-request
                :debug true
                :debug-body true}))

(defn gen-iframe-url
  [iframe-url txn-id]
  (str iframe-url txn-id))

(defn txn-post
  [txn-api-url coda-inquiry]
  (client/post txn-api-url
               {:headers {}
                :content-type :json
                :accept :json
                :form-params coda-inquiry
                :debug true
                :debug-body true}))
(defn -main
  "I don't do a whole lot ... yet."
  [& args]
  (println "Hello, World!"))
