# Codapay
Codapay is a library that ease the adoption of codapay (coda payment gateway) API.

FIXME

## Prerequisites

You will need [Leiningen][1] 2.0 or above installed and clojure "1.7.0". 

[1]: https://github.com/technomancy/leiningen

## Installation

The easiest way is to use Leiningen. Add the following dependency to your
project.clj file:

    [calvin/clj-codapay "0.1.0"]


## Example Usage

```clojure
(ns test
    (:require [clj-codapay.core :as cod]))

(def transaction-items
     [{:code "aptx-001" ;your item code (string)
       :name "body shrinker" ;your item name (string)
       :price 10000000.0 ;your item price (double)
       :type 1 ;codapay item type default value is 1 (int)}])

(def request-map
     {:initRequest
       {:apiKey "api-key", ;apikey (string)	
        :country 300, ;country code provided in coda doc (int) 
        :currency 300, ;currency code provided in coda doc (int)
        :items transaction-items, ;items in transaction (list of map)
        :payType 200, ;method of payment provided in coda doc (list of map)
        :orderId "12098310981", ;unique transaction order id (string)
        :profile {:users_id 1010010} ;purchaser profile (map)}})

(cod/init-request-post "coda-api-init-url" request-map)
;;find your coda-init-url in the doc

=>{:status 200
   :body "\"txnId\":4435593164704715949"}

(cod/gen-iframe-url "coda-api-iframe-url" 4435593164704715949)
;;find your coda-iframe-url in the doc.

=>"coda-api-iframe-url?type=3&txn_id=4435593164704715949"
;embed this link to your iframe and the coda payment interface will appear

;to check the transaction status you can use 'txn-post' function

{def txn-request {:inquiryPaymentRequest
     		  {:apiKey "apikey"
                   :txnId "4435593164704715949"}}}

(cod/txn-post "coda-api-inquirypaymentresult-url" txn-request)
;;find your coda-api-inquirypaymentresult-url in the doc.

=>{:status 200
   :body "{\"paymentResult\":{\"orderId\":12098310981,
           \"profile\":{\"entry\":{\"key\":\"PaymentType\",\"value\":1}},
	   \"resultCode\":401,
	   \"resultDesc\":\"Transaksi ini telah dibatalkan. Anda tidak dikenakan biaya apa pun. (error:401)\",
	   \"totalPrice\":1.0E7,\"txnId\":4435593164704715949}}"}

;You can also generate request map with the provided function
;'init-request' and 'init-item' like explained below.
```

*init-item
This function is generating item map in coda format, take 4 args which is the product code, name, price and type (I don't really understand what is 'type' suppose to mean but it has a default value if you read the coda doc).
If you call

```clojure
(cod/init-item "aptx-001" "body shrinker" "10000000" "1")
=> {:code "aptx-001" :name "body shrinker" :price 10000000.0 :type 1}
```

*init-request
This function is generating item map in coda format, take 7 args.

```clojure
(cod/init-request "apiKey"
	      "300" ;;country code
	      "300" ;;currency code
	      [{:code "aptx-001" :name "body shrinker" :price 10000000.0 :type 1}] ;;item coll
	      "200" ;;payment type
	      "12098310981" ;;order id
	      {:users_id 1010010} ;;user map)
=> {:initRequest
   {:apiKey "api-key",
    :country 300,
    :currency 300,
    :items [{:code "aptx-001" :name "body shrinker" :price 10000000.0 :type 1}],
    :payType 200,
    :orderId "12098310981",
    :profile {:users_id 1010010}}}	     
```

*init-request-post
Basically post the request to codapay server. Send and receive in json you'll get the transaction id here (the most important thing).

*txn-request-post
Post the transaction-id and retrieve the status of that transaction

*gen-iframe-url
Generating coda iframe UI for user to finish the transaction

## License

Copyright © 2015 FIXME
