(defproject ca.brentvatne/cljs-file-api "0.1.0"
  :description "An idiomatic FileAPI interface for ClojureScript."
  :url "https://github.com/brentvatne/cljs-file-api"
  :license {:name "Eclipse"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :scm {:name "git"
        :url "https://github.com/brentvatne/cljs-file-api"}

  :dependencies [[org.clojure/clojure "1.6.0"]
                 [org.clojure/clojurescript "0.0-2727"]
                 [org.clojure/core.async "0.1.346.0-17112a-alpha"]]

  :hooks [leiningen.cljsbuild]

  :plugins [[com.cemerick/clojurescript.test "0.3.3"]
            [lein-cljsbuild "1.0.4"]]

  :aliases {"auto-test" ["do" "clean," "cljsbuild" "auto" "test"]}

  :profiles {:dev {:source-paths ["dev"]
                   :plugins [[com.cemerick/austin "0.1.6"]]}}

  :cljsbuild {:test-commands {"unit-tests" ["phantomjs" :runner "target/testable.js"]}
              :builds {:test {:source-paths ["src" "test"]
                              :notify-command ["phantomjs" :cljs.test/runner "target/testable.js"]
                              :compiler {:output-to "target/testable.js"
                                         :optimizations :whitespace}}
                       :dev {:source-paths ["src"]
                             :compiler {:output-to "target/cljs_file_api.js"
                                        :optimizations :none}}}})
