(ns ca.bigthunder.libs.nrepl
  (:require
   [clojure.tools.nrepl.server :as nrepl]
   [taoensso.timbre :as timbre]))

(defonce this (atom nil))

(defonce default {:port 9001 :bind "localhost"})

(defn start [& args]
  (let [o (first args)
        p (get-in o [:port] (default :port))
        b (get-in o [:bind] (default :bind))]
   (swap! this (fn [_]
                (nrepl/start-server :bind b :port p)))
   (timbre/info "nrepl started at" (str b ":" p)))
  @this)

(defn stop []
  (when @this
    (do
     (nrepl/stop-server @this)
     (timbre/info "nrepl stopped")
     (reset! this nil))))
