(ns retabled.listeners)

(defn on-document-click
  [e PAGING-INFO]
  (when (and (some? e) (some? PAGING-INFO)))
  (let [page-to-go (js/document.getElementById "page-to-go")
        page-to-go-click? (.contains page-to-go e.target)]
    (when (not page-to-go-click?)
      (swap! PAGING-INFO assoc :go-to-value (str (:current-page @PAGING-INFO))))))

(defn activate
  [PAGING-INFO]
  (js/document.addEventListener "click" #(on-document-click % PAGING-INFO)))
