(defproject {{ns-name}} "0.1.0-SNAPSHOT"

  :description "Your ODH Application "
  :url "http://{{ns-name}}.byu.edu"
  :dependencies [
                 [bouncer "1.0.1"] ;; form validation
                 [cider/cider-nrepl "0.15.1"]
                 [clj-http "3.7.0"]
                 [clj-json "0.5.3"]
                 [clj-time "0.14.0"]
                 [cljs-ajax "0.7.2"]
                 [com.cognitect/transit-clj "0.8.300"] ;; TRANSIT json format
                 [com.cognitect/transit-cljs "0.8.243"] ;; TRANSIT json format
                 [com.draines/postal "2.0.2"] ;; Emailing
                 [compojure "1.6.0"]
                 [conman "0.6.9"]
                 [cprop "0.1.11"]
                 [garden "1.3.3"]
                 [hiccup "1.0.5"]
                 [luminus-immutant "0.2.3"]
                 [luminus-migrations "0.4.2"]
                 [luminus-nrepl "0.1.4"]
                 [metosin/ring-http-response "0.9.0"]
                 [mount "0.1.11"] ;; Modular runtime operation
                 ;[org.apache.xmlgraphics/fop "2.1"] ;; maybe if we do pdf gen
                 [org.clojure/clojure "1.9.0-alpha17"]
                 [org.clojure/clojurescript "1.9.946" :scope "provided"]
                 [org.clojure/tools.cli "0.3.5"]
                 [org.clojure/tools.logging "0.4.0"]
                 [org.postgresql/postgresql "42.1.4"] ;; Postgres
                 [org.immutant/web "2.1.9"] ;; Immutant web work
                 [org.webjars.bower/tether "1.4.0"]
                 [org.webjars/bootstrap "4.0.0-alpha.6-1"]
                 [org.webjars/font-awesome "4.7.0"]
                 [org.webjars/webjars-locator-jboss-vfs "0.1.0"]
                 [reagent "0.7.0"] ;; REACT 
                 [reagent-utils "0.2.1"] ;; & REACT
                 [ring-middleware-format "0.7.2"] ;; CLJ Routing
                 [ring-webjars "0.2.0"] ;; Web assetts & their routing
                 [ring/ring-defaults "0.3.1"] ;; CLJ routing
                 [secretary "1.2.3"] ;; CLJS routing
                 [honeysql "0.9.1"] ;; SQL meets clojure
                 [hikari-cp "1.8.1"]
                 [buddy "2.0.0"] ;; Session & Auth
                 ]

  :min-lein-version "2.0.0"

  :jvm-opts ["-server" "-Dconf=.lein-env"]
  :source-paths ["src/clj" "src/cljc"]
  :resource-paths ["resources" "target/cljsbuild"]
  :target-path "target/%s/"
  :main {{ns-name}}.core
  :plugins [[lein-cprop "1.0.1"]
            [migratus-lein "0.4.1"]
            [lein-cljsbuild "1.1.4"]
            [lein-garden "0.3.0"]
            [lein-immutant "2.1.0"]]
  :immutant {:war {:name "humfunding"
                   :main humfunding.core}}
  :garden {:builds [{:id "{{ns-name}}"
                     :source-path "src/clj"
                     :stylesheet {{ns-name}}.styles.main/{{ns-name}}
                     :compiler {:output-to "resources/public/css/style.css"
                                :pretty-print? true}}]}
  :clean-targets ^{:protect false}
  [:target-path [:cljsbuild :builds :app :compiler :output-dir] [:cljsbuild :builds :app :compiler :output-to]]
  :figwheel
  {:http-server-root "public"
   :nrepl-port 7002
   :css-dirs ["resources/public/css"]
   :nrepl-middleware [cemerick.piggieback/wrap-cljs-repl]}
  

  :profiles
  {:uberjar {:omit-source true
             :prep-tasks ["compile" ["cljsbuild" "once" "min"]]
             :cljsbuild
             {:builds
              {:min
               {:source-paths ["src/cljc" "src/cljs" "env/prod/cljs"]
                :compiler
                {:output-to "target/cljsbuild/public/js/app.js"
                 :externs ["react/externs/react.js"]
                 :optimizations :advanced
                 :pretty-print false
                 :closure-warnings
                 {:externs-validation :off :non-standard-jsdoc :off}}}}}
             
             
             :aot :all
             :uberjar-name "{{ns-name}}.jar"
             :source-paths ["env/prod/clj"]
             :resource-paths ["env/prod/resources"]}

   :dev           [:project/dev :profiles/dev]
   :test          [:project/test :profiles/test]

   :project/dev  {:dependencies [[prone "1.1.4"]
                                 [garden-gnome "0.1.0"]
                                 [ring/ring-mock "0.3.1"]
                                 [ring/ring-devel "1.6.2"]
                                 [pjstadig/humane-test-output "0.8.3"]
                                 [doo "0.1.8"]
                                 [binaryage/devtools "0.9.7"]
                                 [figwheel-sidecar "0.5.14"]
                                 [com.cemerick/piggieback "0.2.2"]]
                  :plugins      [[com.jakemccrary/lein-test-refresh "0.14.0"]
                                 [lein-doo "0.1.7"]
                                 [lein-figwheel "0.5.12"]
                                 [org.clojure/clojurescript "1.9.946"]]
                  :cljsbuild
                  {:builds
                   {:app
                    {:source-paths ["src/cljs" "src/cljc" "env/dev/cljs"]
                     :compiler
                     {:main "{{ns-name}}.app"
                      :asset-path "/js/out"
                      :output-to "target/cljsbuild/public/js/app.js"
                      :output-dir "target/cljsbuild/public/js/out"
                      :source-map true
                      :optimizations :none
                      :pretty-print true}}}}
                  :doo {:build "test"}
                  :source-paths ["env/dev/clj" "test/clj"]
                  :resource-paths ["env/dev/resources"]
                  :repl-options {:init-ns user}
                  :injections [(require 'pjstadig.humane-test-output)
                               (pjstadig.humane-test-output/activate!)]}
   :project/test {:resource-paths ["env/dev/resources" "env/test/resources"]
                  :cljsbuild
                  {:builds
                   {:test
                    {:source-paths ["src/cljc" "src/cljs" "test/cljs"]
                     :compiler
                     {:output-to "target/test.js"
                      :main "{{ns-name}}.doo-runner"
                      :optimizations :whitespace
                      :pretty-print true}}}}
                  
                  }
   :profiles/dev {}
   :profiles/test {}}
  )
