(ns user
  (:require [mount.core :as mount]
            [garden-gnome.watcher :as garden-gnome]
            [{{ns-name}}.figwheel :refer [start-fw stop-fw cljs]]
            {{ns-name}}.core))

(mount/defstate garden
  :start (garden-gnome/start! (garden-gnome/default-config))
  :stop (garden-gnome/stop! garden))

(defn start []
  (mount/start-without #'{{ns-name}}.core/repl-server))

(defn stop []
  (mount/stop-except #'{{ns-name}}.core/repl-server))

(defn restart []
  (stop)
  (start))


