(ns burningswell.worker.json
  (:require [burningswell.json :as json]
            [burningswell.worker.driver :as driver]
            [burningswell.worker.topics :as topics]
            [com.stuartsierra.component :as component]
            [jackdaw.streams :as j]))

(defn config
  "Returns the config for the json app."
  [& [opts]]
  (-> {:application
       {"application.id" "json"
        "bootstrap.servers" (:bootstrap.servers opts)
        "cache.max.bytes.buffering" "0"}
       :topics {topics/api-commands-edn topics/api-commands-json
                topics/api-events-edn topics/api-events-json}}
      (merge opts)))

(defn build-topology [app builder]
  (doseq [[input output] (-> app :config :topics)]
    (-> (j/kstream builder input)
        (j/to output))))

(defrecord JSON [config driver]
  component/Lifecycle
  (start [app]
    (driver/start driver app))

  (stop [app]
    (driver/stop driver app))

  driver/Application
  (config [app]
    (:application config))

  (topology [app builder]
    (build-topology app builder)))

(defn json
  "Returns the JSON topology."
  [& [opts]]
  (-> (map->JSON {:config (config opts)})
      (component/using [:driver])))
