(ns burningswell.worker.pprint
  (:require [burningswell.worker.driver :as driver]
            [clojure.pprint :as pprint]
            [com.stuartsierra.component :as component]
            [jackdaw.streams :as j]))

(defn- config
  "Returns the config for the pprint app."
  [& [opts]]
  (-> {:application
       {"application.id" "pprint"
        "bootstrap.servers" (:bootstrap.servers opts)
        "cache.max.bytes.buffering" "0"}}
      opts))

(defn- build-topology [app builder]
  (-> (j/kstream builder (-> app :config :input))
      (j/map-values (fn [v]
                      (locking *out* (pprint/pprint v))
                      v))))

(defrecord PrettyPrint [config driver]
  component/Lifecycle
  (start [app]
    (driver/start driver app))

  (stop [app]
    (driver/stop driver app))

  driver/Application
  (config [app]
    (:application config))

  (topology [app builder]
    (build-topology app builder)))

(defn pprint
  "Returns the JSON topology."
  [& [opts]]
  (-> (map->PrettyPrint {:config (config opts)})
      (component/using [:driver])))
