(defproject burningswell/worker "0.2.1"
  :description "The Burning Swell streaming services"
  :url "https://gitlab.com/burningswell/worker"
  :license {:name "Creative Commons Attribution-NonCommercial 3.0"
            :url "http://creativecommons.org/licenses/by-nc/3.0/"}
  :deploy-repositories [["releases" :clojars]]
  :dependencies [[burningswell/core "0.0.79"]
                 [burningswell/config "0.1.56"]
                 [burningswell/db "0.3.46"]
                 [burningswell/specs "0.1.5"]
                 [burningswell/transit "0.1.3"]
                 [cheshire "5.8.1"]
                 [com.damballa/abracad "0.4.13"]
                 [ch.qos.logback/logback-core "1.2.3"]
                 [ch.qos.logback/logback-classic "1.2.3"]
                 [com.google.cloud/google-cloud-storage "1.57.0"]
                 [com.google.cloud/google-cloud-vision "1.57.0"]
                 [com.taoensso/timbre "4.10.0"]
                 [expound "0.7.2"]
                 ;; [fundingcircle/jackdaw "0.4.1"]
                 [r0man/jackdaw "0.4.2-edn-opts-SNAPSHOT"
                  :exclusions [org.slf4j/slf4j-log4j12]]
                 [geocoder-clj "0.2.6"]
                 [image-resizer "0.1.10"]
                 [medley "1.0.0"]
                 [netcdf-clj "0.0.16" :exclusions [com.amazonaws/aws-java-sdk-s3 org.slf4j/slf4j-log4j12]]
                 [org.apache.kafka/kafka-clients "2.1.0"]
                 [org.apache.kafka/kafka-streams "2.1.0"]
                 [org.bouncycastle/bcprov-jdk15on "1.60"]
                 [org.clojure/clojure "1.10.0"]
                 [pandect "0.6.1"]
                 [peripheral "0.5.3"]
                 [potemkin "0.4.5"]
                 [rads/kafka.transit "0.3.0" :exclusions [org.apache.kafka/kafka_2.11]]
                 [ring/ring-codec "1.1.1"]]
  :aliases
  {"ci" ["do" ["clean"] ["difftest"] ["lint"]]
   "consumer" ["run" "-m" "burningswell.worker.console.consumer"]
   "lint" ["do" ["eastwood"]]}
  :eastwood {:config-files ["test-resources/eastwood.clj"]
             :exclude-linters [:deprecations
                               :local-shadows-var
                               :implicit-dependencies]}
  :main ^{:skip-aot true} burningswell.worker.main
  :plugins [[lein-environ "1.1.0"]]
  :profiles {:dev {:dependencies [[clj-http-fake "1.0.3"]
                                  [org.apache.kafka/kafka-streams-test-utils "2.1.0"]
                                  [org.clojure/test.check "0.9.0"]
                                  [reloaded.repl "0.2.4"]]
                   :plugins [[jonase/eastwood "0.3.4"]
                             [lein-cloverage "1.0.13"]
                             [lein-difftest "2.0.0"]
                             [listora/whitespace-linter "0.1.0"]]}
             :repl {:repl-options {:init-ns user}
                    :source-paths ["dev"]}
             :test {:resource-paths ["test-resources"]}
             :uberjar {:aot :all}}
  :repositories {"confluent" "https://packages.confluent.io/maven/"
                 "unidata" "https://artifacts.unidata.ucar.edu/content/repositories/unidata-releases"}
  :uberjar-name "burningswell-worker.jar")

;; Cascalog uses insecure conjars repo
(require 'cemerick.pomegranate.aether)
(cemerick.pomegranate.aether/register-wagon-factory!
 "http" #(org.apache.maven.wagon.providers.http.HttpWagon.))
