(ns burningswell.worker.topology
  (:require [burningswell.rabbitmq.client :as rabbitmq]
            [com.stuartsierra.component :as component]
            [kithara.rabbitmq.exchange :as exchange]))

(defn declare-exchanges
  "Declare the exchanges of the worker topology."
  [topology channel]
  (->> {:api (exchange/declare channel :api :topic {:durable? true})
        :worker (exchange/declare channel :worker :topic {:durable? true})}
       (assoc topology :exchanges)))

(defn declare-topology
  "Declare the worker topology."
  [topology channel]
  (declare-exchanges topology channel))

(defrecord Topology [broker]
  component/Lifecycle
  (start [topology]
    (rabbitmq/with-channel [channel broker]
      (declare-topology topology channel)))
  (stop [topology]
    topology))

(defn topology [broker]
  (-> (map->Topology {:broker broker})
      (component/using [:broker])))
