(ns burningswell.worker.config
  (:refer-clojure :exclude [import])
  (:require [burningswell.config.core :as config]))

(defn addresses
  "Return the config for the address worker from `env`."
  [env]
  {:broker (config/broker env)})

(defn flickr
  "Return the config for the flickr worker from `env`."
  [env]
  {:aws (config/aws env)
   :flickr (config/flickr env)})

(defn import
  "Return the config for the import worker from `env`."
  [env]
  {:broker (config/broker env)})

(defn photos
  "Return the config for the photo worker from `env`."
  [env]
  {:broker (config/broker env)
   :google (config/google env)})

(defn spot-weather
  "Return the config for the weather worker from `env`."
  [env]
  {:broker (config/broker env)})

(defn config
  "Return the config for the worker system from `env`."
  [env]
  (merge
   (config/worker env)
   {:addresses (addresses env)
    :db (config/db env)
    :broker (config/broker env)
    :import (import env)
    :google (config/google env)
    :flickr (flickr env)
    :photos (photos env)
    :spot-weather (spot-weather env)}))
