(defproject burningswell/worker "0.1.26"
  :description "The Burning Swell workers"
  :url "https://github.com/burningswell/worker"
  :license {:name "Creative Commons Attribution-NonCommercial 3.0"
            :url "http://creativecommons.org/licenses/by-nc/3.0/"}
  :min-lein-version "2.0.0"
  :deploy-repositories [["releases" :clojars]]
  :dependencies [[burningswell/config "0.1.47"]
                 [burningswell/core "0.0.53"]
                 [burningswell/db "0.3.8"]
                 [burningswell/metrics "0.1.5"]
                 [burningswell/rabbitmq "0.3.2"
                  :exclusions [com.novemberain/langohr]]
                 [ch.qos.logback/logback-classic "1.2.3"]
                 [ch.qos.logback/logback-core "1.2.3"]
                 [com.google.cloud/google-cloud-storage "1.15.0"]
                 [com.google.cloud/google-cloud-vision "1.15.0"]
                 [com.taoensso/timbre "4.10.0"]
                 [geocoder-clj "0.2.6"]
                 [image-resizer "0.1.10"]
                 [sqlingvo "0.9.19"]
                 [datumbazo "0.13.10"]
                 [listora/again"0.1.0"]
                 [medley "1.0.0"]
                 [metrics-clojure "2.10.0"]
                 [netcdf-clj "0.0.16"
                  :exclusions [com.amazonaws/aws-java-sdk-s3
                               org.slf4j/slf4j-log4j12]]
                 [org.bouncycastle/bcprov-jdk15on "1.59"]
                 [org.clojure/clojure "1.9.0"]
                 [pandect "0.6.1"]
                 [potemkin "0.4.4"]
                 [ring/ring-codec "1.1.0"]]
  :plugins [[lein-environ "1.1.0"]]
  :aliases {"ci" ["do" ["test"] ["lint"]]
            "lint" ["do" ["whitespace-linter"] ["eastwood"]]}
  :eastwood {:config-files ["test-resources/eastwood.clj"]}
  :main ^{:skip-aot true} burningswell.worker.main
  :profiles {:dev {:dependencies [[reloaded.repl "0.2.4"]]
                   :plugins [[jonase/eastwood "0.2.5"]
                             [lein-difftest "2.0.0"]
                             [listora/whitespace-linter "0.1.0"]]
                   :repl-options {:init-ns user}
                   :source-paths ["dev" "src"]}
             :gitlab {:env
                      {:bs-broker-password "guest"
                       :bs-broker-server-name "rabbitmq"
                       :bs-broker-username "guest"
                       :bs-broker-vhost "/"}}
             :test {:source-paths ^:replace ["src"]
                    :resource-paths ["test-resources"]}
             :uberjar {:aot :all :main burningswell.worker.main}}
  :repositories {"unidata" "https://artifacts.unidata.ucar.edu/content/repositories/unidata-releases"}
  :uberjar-name "burningswell-worker.jar")

;; Cascalog uses insecure conjars repo
(require 'cemerick.pomegranate.aether)
(cemerick.pomegranate.aether/register-wagon-factory!
 "http" #(org.apache.maven.wagon.providers.http.HttpWagon.))
