(defproject burningswell/worker "0.1.21"
  :description "The Burning Swell workers"
  :url "https://github.com/burningswell/worker"
  :license {:name "Creative Commons Attribution-NonCommercial 3.0"
            :url "http://creativecommons.org/licenses/by-nc/3.0/"}
  :min-lein-version "2.0.0"
  :deploy-repositories [["releases" :clojars]]
  :dependencies [[burningswell/config "0.1.39"]
                 [burningswell/core "0.0.49"]
                 [burningswell/db "0.0.102"]
                 [burningswell/rabbitmq "0.3.2"
                  :exclusions [com.novemberain/langohr]]
                 [ch.qos.logback/logback-classic "1.1.8"]
                 [ch.qos.logback/logback-core "1.1.8"]
                 [com.google.cloud/google-cloud-storage "0.7.0"]
                 [com.google.apis/google-api-services-vision "v1-rev30-1.22.0"
                  :exclusions [[com.google.guava/guava-jdk5]]]
                 [geocoder-clj "0.2.5"]
                 [image-resizer "0.1.9"]
                 [listora/again"0.1.0"]
                 [medley "0.8.4"]
                 [metrics-clojure "2.7.0"]
                 [netcdf-clj "0.0.13"
                  :exclusions [com.amazonaws/aws-java-sdk-s3
                               org.slf4j/slf4j-log4j12]]
                 [org.bouncycastle/bcprov-jdk15on "1.55"]
                 [org.clojure/clojure "1.9.0-alpha14"]
                 [pandect "0.6.1"]
                 [potemkin "0.4.3"]
                 [ring/ring-codec "1.0.1"]]
  :plugins [[lein-environ "1.1.0"]]
  :aliases {"ci" ["do" ["difftest"] ["lint"]]
            "lint" ["do" ["whitespace-linter"] ["eastwood"]]}
  :eastwood {:config-files ["test-resources/eastwood.clj"]}
  :main ^{:skip-aot true} burningswell.worker.main
  :profiles {:dev {:dependencies [[reloaded.repl "0.2.3"]]
                   :plugins [[jonase/eastwood "0.2.3"]
                             [lein-difftest "2.0.0"]
                             [listora/whitespace-linter "0.1.0"]]
                   :repl-options {:init-ns user}
                   :source-paths ["dev" "src"]}
             :test {:source-paths ^:replace ["src"]
                    :resource-paths ["test-resources"]}
             :uberjar {:aot :all :main burningswell.worker.main}}
  :repositories {"unidata" "https://artifacts.unidata.ucar.edu/content/repositories/unidata-releases"}
  :uberjar-name "burningswell-worker.jar")
