(ns burningswell.worker.topology
  (:require [burningswell.rabbitmq.client :as rabbitmq]
            [com.stuartsierra.component :as component]
            [kithara.rabbitmq.exchange :as exchange]))

(defn declare-exchanges [broker]
  (rabbitmq/with-connection [client broker]
    (rabbitmq/with-channel [channel client]
      (exchange/declare channel :api :topic {:durable? true}))))

(defrecord Topology [broker]
  component/Lifecycle
  (start [topology]
    (declare-exchanges broker)
    topology)
  (stop [topology]
    topology))

(defn new-topology [broker]
  (map->Topology {:broker broker}))
