(defproject burningswell/worker "0.1.15"
  :description "The Burning Swell workers"
  :url "https://github.com/burningswell/worker"
  :license {:name "Creative Commons Attribution-NonCommercial 3.0"
            :url "http://creativecommons.org/licenses/by-nc/3.0/"}
  :min-lein-version "2.0.0"
  :deploy-repositories [["releases" :clojars]]
  :dependencies [[burningswell/config "0.1.38"]
                 [burningswell/core "0.0.46"]
                 [burningswell/db "0.0.87"]
                 [burningswell/rabbitmq "0.3.0"]
                 [ch.qos.logback/logback-classic "1.1.7"]
                 [ch.qos.logback/logback-core "1.1.7"]
                 [clj-aws-s3 "0.3.10"
                  :exclusions [clj-time
                               joda-time
                               org.apache.httpcomponents/httpclient
                               org.apache.httpcomponents/httpcomponents-core
                               org.apache.httpcomponents/httpcomponents-client
                               org.apache.httpcomponents/httpcore
                               org.apache.httpcomponents/httpmime]]
                 [geocoder-clj "0.2.5"]
                 [image-resizer "0.1.9"]
                 [listora/again"0.1.0"]
                 [netcdf-clj "0.0.13"
                  :exclusions [com.amazonaws/aws-java-sdk-s3
                               org.slf4j/slf4j-log4j12]]
                 [org.bouncycastle/bcprov-jdk15on "1.55"]
                 [org.clojure/clojure "1.8.0"]                 
                 [pandect "0.6.1"]
                 [potemkin "0.4.3"]
                 [ring/ring-codec "1.0.1"]]
  :plugins [[lein-environ "1.1.0"]]
  :aliases {"ci" ["do" ["difftest"] ["lint"]]
            "lint" ["do" ["whitespace-linter"] ["eastwood"]]}
  :eastwood {:config-files ["test-resources/eastwood.clj"]}
  :main ^{:skip-aot true} burningswell.worker.main
  :profiles {:dev {:dependencies [[reloaded.repl "0.2.3"]]
                   :plugins [[jonase/eastwood "0.2.3"]
                             [lein-difftest "2.0.0"]
                             [listora/whitespace-linter "0.1.0"]]
                   :repl-options {:init-ns user}
                   :source-paths ["dev" "src"]}
             :test {:source-paths ^:replace ["src"]
                    :resource-paths ["test-resources"]}
             :uberjar {:aot :all :main burningswell.worker.main}}
  :repositories {"unidata" "https://artifacts.unidata.ucar.edu/content/repositories/unidata-releases"}
  :uberjar-name "burningswell-worker.jar")
