(ns burningswell.worker.spot-weather
  (:require [burningswell.db.schemas :refer :all]
            [burningswell.db.spots :as spots]
            [burningswell.db.weather :as weather]
            [burningswell.worker.subscriber :refer [subscriber]]
            [schema.core :as s])
  (:import burningswell.worker.subscriber.Subscriber
           com.rabbitmq.client.Channel))

(s/defn ^:always-validate on-spot-created
  "Create the weather current forecast for `spot`."
  [worker :- Subscriber channel :- Channel metadata :- s/Any spot :- Spot]
  (let [db (:db worker)]
    (when-let [spot (spots/by-id db (:id spot))]
      (weather/import-spot-forecasts db {:spots [spot]})
      @(weather/refresh-3-hourly-spot-weather db))))

(def subscriptions
  [{:name ::spot-created
    :exchange {:name "api" :type :topic :durable true}
    :handler on-spot-created
    :routing-keys ["spots.created"]
    :queue {:name "weather.spots.created"
            :auto-delete false
            :durable true}
    :dead-letter true}])

(defn new-worker
  "Return a new Flickr worker."
  [& [config]]
  (subscriber subscriptions config))
