(ns burningswell.worker.main
  (:require [burningswell.system :as system]
            [burningswell.worker.config :refer [config]]
            [burningswell.worker.system :refer [new-system]]
            [com.stuartsierra.component :as component]
            [environ.core :refer [env]])
  (:gen-class))

(defn -main [& args]
  (system/with-system [system (new-system (config env))]
    (system/on-shutdown #(component/stop system))
    (loop []
      (Thread/sleep 10000)
      (recur))))
