(ns burningswell.worker.config
  (:require [burningswell.config.core :as config]))

(defn flickr [env]
  {:aws (config/aws env)
   :flickr (config/flickr env)
   :s3 (config/s3 env)})

(defn photos [env]
  {:aws (config/aws env)
   :s3 (config/s3 env)})

(defn config [env]
  {:db (config/db env)
   :broker (config/broker env)
   :flickr (flickr env)
   :photos (photos env)})
