(ns burningswell.web.ui.social
  (:require [sablono.core :refer [html]]))


(defn social-image-url [provider]
  (str "/images/logos/bw/" (name provider) ".svg"))

(defn social-connect-url [provider]
  (str "http://localhost:8001/oauth/" (name provider) "/connect"))

(defn connect-button [provider]
  (html
   [:a.social-connect-button
    {:href (social-connect-url provider)}
    [:img.social-connect-button__image
     {:src (social-image-url provider)}]]))

(defn connect []
  (html
   [:div.social-connect
    (connect-button :facebook)
    (connect-button :google)
    (connect-button :twitter)]))
