(ns burningswell.web.ui.buttons
  (:require ["@material/react-button" :default Button]
            ["@material/react-icon-button" :default IconButton]
            [react :as React :refer [createElement]]))

(defn button [text & [opts]]
  (createElement
   Button
   #js {:children text
        :disabled (:disabled opts)
        :onClick (:on-click opts)
        :raised (:raised opts)}))

(defn icon-button
  [child & [{:keys [class disabled on-click]}]]
  (createElement
   IconButton
   #js {:children child
        :className class
        :onClick (or on-click identity)
        :disabled disabled}))
