(ns burningswell.web.pages.spot
  (:require [apollo.core :as a]
            [burningswell.web.ui.layout :as layout]
            [burningswell.web.ui.links :as links]
            [burningswell.web.ui.pages :as pages]
            [cljs.loader :as loader]))

(a/defgql spot-query
  '((query
     spot
     [($slug String)]
     ((spot node)
      [(slug $slug)]
      (... spot)))
    (fragment
     spot (on Spot)
     id name
     (country
      id name
      (slug path))
     (region
      id name
      (slug path))
     (slug path))))

(defn main [route]
  (a/query
   {:query spot-query
    :variables {:slug (:uri route)}}
   (fn [{:keys [client data error loading]}]
     (pages/page
      {:name "spot"
       :title (-> data :spot :name)}
      (cond
        error
        [:div "Error :("]
        loading
        [:div "Loading ..."]
        :else
        (let [{:keys [spot]} data]
          (layout/grid
           {}
           (layout/row
            {}
            (layout/cell
             {:columns 12}
             [:h1.mdc-typography--headline5
              (-> data :spot :name)]
             (links/region (:region spot))
             (links/country (:country spot)))))))))))

(when (exists? js/window)
  (loader/set-loaded! :spot))
