(ns burningswell.web.pages.map
  (:require [apollo.core :as a]
            [burningswell.web.ui.layout :as layout]
            [burningswell.web.ui.lists :as lists]
            [burningswell.web.ui.google-maps :as google-maps]
            [burningswell.web.ui.pages :as pages]
            [cljs.loader :as loader]))

(defn main []
  (a/with-query [{:keys [data]}]
    {:query (a/ast '((location ((client)) latitude longitude)))}
    (let [location (:location data)]
      (pages/page
       {:name "map"
        :title "Map"}
       [:div
        (layout/grid
         {}
         (layout/row
          {}
          (layout/cell
           {:columns 12}
           (google-maps/google-map
            {:center location
             :zoom 8
             :on-idle #(prn "IDLE" (google-maps/center %))})))

         (layout/row
          {}
          (layout/cell
           {:desktop 3
            :phone 2
            :tablet 2}
           (lists/spots))

          (layout/cell
           {:desktop 3
            :phone 2
            :tablet 2}
           (lists/regions))

          (layout/cell
           {:desktop 3
            :phone 2
            :tablet 2}
           (lists/countries))

          (layout/cell
           {:desktop 3
            :phone 2
            :tablet 2}
           (lists/continents))))]))))

(when (exists? js/window)
  (loader/set-loaded! :map))
