(ns burningswell.web.pages.continent
  (:require [apollo.core :as a]
            [burningswell.web.ui.layout :as layout]
            [burningswell.web.ui.lists :as lists]
            [burningswell.web.ui.pages :as pages]
            [cljs.loader :as loader]
            [sablono.core :refer [html]]))

(a/defgql continent-query
  '((query
     continent
     [($slug String)]
     ((continent node)
      [(slug $slug)]
      (... continent)))
    (fragment
     continent (on Continent)
     id name
     (slug path))))

(defn main [route]
  (a/query
   {:query continent-query
    :variables {:slug (:uri route)}}
   (fn [{:keys [client data error loading]}]
     (pages/page
      {:name "continent"
       :title (-> data :continent :name)}
      (cond
        error
        [:div "Error :("]
        loading
        [:div "Loading ..."]
        :else
        (layout/grid
         {}
         (layout/row
          {}
          (layout/cell
           {:columns 12}
           (let [{:keys [continent]} data]
             [:div.continent-page__content
              (:name continent)
              (lists/countries {:continents [(:id continent)]})])))))))))

(when (exists? js/window)
  (loader/set-loaded! :continent))
