(ns burningswell.web.cookies
  (:require [burningswell.web.logging :as log]
            [goog.crypt.base64 :as base64])
  (:import [goog.net Cookies]))

(def logger
  "The logger of the current namespace."
  (log/logger (namespace ::logger)))

(def cookies
  (when (exists? js/document)
    (Cookies. js/document)))

(defn remove-cookie!
  "Remove the cookie `name`."
  [name]
  (when cookies
    (let [name (clojure.core/name name)]
      (.remove cookies name)
      (log/info logger (str "Removed cookie " name ".")))))

(defn set-cookie!
  "Set a cookie `name` to `value`."
  [name value & [{:keys [path domain max-age secure?]}]]
  (when cookies
    (let [name (clojure.core/name name)]
      (.set cookies name value
            (or max-age -1) ;; -1 is session cookie
            path
            domain
            (true? secure?))
      (log/info logger (str "Set cookie " name " to " value ".")))))
