(ns burningswell.web.ui.links
  (:require [burningswell.web.history :as history]
            [burningswell.web.ui.system :as system]
            [sablono.core :refer [html]]))

(defn link [opts & content]
  (system/consumer
   (fn [{:keys [history]}]
     (let [on-click (fn [event]
                      (.preventDefault event)
                      (.stopPropagation event)
                      (some->> (:href opts) (history/set-path! history)))
           opts (assoc opts :on-click on-click)]
       (html (into [:a.link opts] content))))))

(defn continent [continent]
  (when (:name continent)
    (link {:class "continent-link"
           :href (-> continent :slug :path)}
          (:name continent))))

(defn country [country]
  (when (:name country)
    (link {:class "continent-link"
           :href (-> country :slug :path)}
          (:name country))))

(defn reset-password []
  (link {:class "reset-password-link"
         :href "/reset-password"}
        "Forgot your password?"))

(defn region [region]
  (when (:name region)
    (link {:class "region-link"
           :href (-> region :slug :path)}
          (:name region))))

(defn signup []
  (link {:class "signup-link"
         :href "/signup"}
        "Create an account."))

(defn signin []
  (link {:class "signin-link"
         :href "/signin"}
        "Signin."))

(defn terms-of-service []
  (link {:class "terms-of-service-link"
         :href "/terms-of-service"}
        "terms of service"))

(defn privacy-statement []
  (link {:class "privacy-statement"
         :href "/privacy-statement"}
        "privacy statement"))
