(ns burningswell.web.ui.icon
  (:require ["@material/react-material-icon" :default Icon]
            [apollo.core :as a]
            [react :as React :refer [createElement]]))

(defn icon
  [type & [{:keys [class has-ripple key on-click]}]]
  (createElement
   Icon
   #js {:className class
        :key (or key (str "icon-" (name type)))
        :hasRipple has-ripple
        :icon (name type)
        :onClick on-click}))
