(ns burningswell.web.ui.google-maps
  (:require [sablono.core :refer [html]]
            [react :as React]))

(defn location->js
  "Convert a location map to a Google Maps LatLng object."
  [{:keys [latitude longitude]}]
  (when (and latitude longitude)
    #js {:lat latitude :lng longitude}))

(defn js->location
  "Convert a Google Maps LatLng object to a map."
  [lat-lng]
  (when lat-lng
    {:latitude (.lat lat-lng)
     :longitude (.lng lat-lng)}))

(defn- map-opts
  "Returns the google maps options."
  [{:keys [center zoom]}]
  #js {:center (location->js center)
       :zoom zoom})

(defn- create-map
  "Create a new google map."
  [element & [opts]]
  (js/google.maps.Map. element (map-opts opts)))

(defn center
  "Returns the center of the google map."
  [google-map]
  (js->location (.getCenter google-map)))

(defn- google-map* [props]
  (let [opts (.-state props)
        ref (React/useRef nil)
        [map set-map!] (React/useState nil)]
    (React/useEffect
     (fn []
       (when-not map
         (prn "GOOGLE MAP WILL MOUNT")
         (let [map (create-map (.-current ref) opts)
               on-idle (when-let [on-idle (:on-idle opts)]
                         (prn "ADD EVENT LISTENER")
                         (.addListener map "idle" #(on-idle map)))]
           (set-map! map)))
       (fn []
         (when map
           (prn "GOOGLE MAP WILL UNMOUNT" ref)
           ;; TODO: How to clean on-idle?
           #_(some-> on-idle js/google.maps.event.removeListener)))))
    (html [:div.google-maps {:ref ref}])))

(defn google-map [& [{:keys [center zoom] :as opts}]]
  (React/createElement google-map* #js {:state opts}))

(defn- counter* []
  (let [[count set-count] (React/useState 0)]
    (prn count)
    (html
     [:div
      [:p "You clicked" count "times"]
      [:button
       {:on-click #(set-count (inc count))}
       "Click me"]])))

(defn counter []
  (React/createElement counter*))
