(ns burningswell.web.ui.auto-complete.regions
  (:require [burningswell.web.ui.icon :refer [icon]]
            [burningswell.web.ui.util :as util]
            [sablono.core :refer [html]]))

(def fragment
  "The auto complete fragment for a region."
  '(fragment
    region (on Region)
    id name spot-count
    (country id name iso-3166-1-alpha-2)
    (slug path)))

(defn suggestion
  "Render the auto complete suggestion for a region."
  [{:keys [country] :as region}]
  (html
   [:div.auto-complete-result.auto-complete-result--region {}
    [:div.auto-complete-result__icon {}
     (icon "account_balance")]
    [:div.auto-complete-result__title {}
     (util/country-flag country)
     (:name region)]
    [:div.auto-complete-result__subtitle {}
     (:name country) ", "
     (-> country :continent :name)]
    [:div.auto-complete-result__details {}
     (util/pluralize (:spot_count region) "spot")]]))
