(ns ^:figwheel-always burningswell.web.server
  (:require [burningswell.web.server.bootstrap]
            [burningswell.config.core :as config]
            [burningswell.web.server.system :as system]
            [clojure.pprint :refer [pprint]]
            [com.stuartsierra.component :as component]
            [environ.core :as environ]))

(defonce +system+
  (volatile! nil))

#_(.on js/process "uncaughtException" #(js/console.error %))
(.on js/process "uncaughtException" #(pprint %))

(defn start []
  (let [config (:config @+system+)
        system (system/system config)]
    (vreset! +system+ (component/start system))))

(defn stop [done]
  (let [stopped (component/stop @+system+)]
    (vreset! +system+ stopped))
  (done))

(defn main [& args]
  ;; (enable-console-print!)
  (let [config (config/web environ/env)
        system (system/system config)]
    (vreset! +system+ (component/start system))))

(set! *main-cli-fn* main)
