(ns burningswell.web.pages.home
  (:require [apollo.core :as a]
            [burningswell.web.ui.auto-complete :refer [auto-complete]]
            [burningswell.web.ui.layout :as layout]
            [burningswell.web.ui.lists :as lists]
            [burningswell.web.ui.pages :as pages]
            [cljs.loader :as loader]))

(defn main []
  (a/with-query [{:keys [data]}]
    {:query (a/ast '((location ((client)) latitude longitude)))}
    (let [location (:location data)]
      (pages/page
       {:name "home"
        :title "Home"}
       (layout/grid
        {}
        (layout/row
         {}
         #_(layout/cell
          {:columns 12}
          (auto-complete
           {:id "auto-complete"
            :on-change #(prn "CHANGE" %)
            :on-select #(prn "SELECT" %)
            :on-submit #(prn "SUBMIT" %)})
          (lists/divider))

         (layout/cell
          {:columns 12}
          (lists/spots
           {:location location
            :sort (if location "DISTANCE" "NAME")})
          (lists/divider))

         (layout/cell
          {:columns 12}
          (lists/regions
           {:location location
            :sort (if location "DISTANCE" "NAME")})
          (lists/divider))

         (layout/cell
          {:columns 12}
          (lists/countries
           {:location location
            :sort (if location "DISTANCE" "NAME")})
          (lists/divider))

         (layout/cell
          {:columns 12}
          (lists/continents
           {:location location
            :sort (if location "DISTANCE" "NAME")})
          (lists/divider))))))))

(when (exists? js/window)
  (loader/set-loaded! :home))
