(ns burningswell.web.ui.cards.core
  (:require ["@material/react-card"
             :default Card
             :refer [CardActionButtons
                     CardActionIcons
                     CardActions
                     CardMedia
                     CardPrimaryContent]]
            [apollo.core :as a]
            [react :as React :refer [createElement]]
            [sablono.core :refer [html]]))

(defn create-card
  [{:keys [class]} & children]
  (apply createElement Card
         #js {:className class}
         (html children)))

(defn create-primary-content
  [{:keys [class on-click]} & children]
  (apply createElement CardPrimaryContent
         #js {:className class
              :onClick on-click}
         (html children)))

(defn create-card-actions
  [{:keys [class]} & children]
  (apply createElement CardActions
         #js {:className class}
         (html children)))

(defn create-card-action-buttons
  [{:keys [class]} & children]
  (apply createElement CardActionButtons
         #js {:className class}
         (html children)))

(defn create-card-action-icons
  [{:keys [class]} & children]
  (apply createElement CardActionIcons
         #js {:className class}
         (html children)))

(defn create-card-media
  [{:keys [class content-class-name image-url square wide]} & children]
  (apply createElement CardMedia
         #js {:className class
              :contentClassName content-class-name
              :imageUrl image-url
              :square square
              :wide wide}
         (html children)))
