(ns burningswell.web.ui.auto-complete.continents
  (:require [burningswell.web.ui.icon :refer [icon]]
            [burningswell.web.ui.util :as util]
            [sablono.core :refer [html]]))

(def fragment
  "The auto complete fragment for a continent."
  '(fragment
    continent (on Continent)
    id name
    (slug path)))

(defn suggestion
  "Render the auto complete suggestion for a continent."
  [{:keys [country] :as continent}]
  (html
   [:div.auto-complete-result.auto-complete-result--continent
    [:div.auto-complete-result__icon {}
     (icon "map")]
    [:div.auto-complete-result__title {}
     (util/country-flag country)
     (:name continent)]
    [:div.auto-complete-result__subtitle {}
     (:name country) ", "
     (-> country :continent :name)]]))
