(ns burningswell.web.pages.country
  (:require [apollo.core :as a]
            [burningswell.web.ui.layout :as layout]
            [burningswell.web.ui.links :as links]
            [burningswell.web.ui.lists :as lists]
            [burningswell.web.ui.pages :as pages]
            [cljs.loader :as loader]))

(a/defgql country-query
  '((query
     country
     [($slug String)]
     ((country node)
      [(slug $slug)]
      (... country)))
    (fragment
     country (on Country)
     id name
     (continent
      id name
      (slug path))
     (slug path))))

(defn main [route]
  (a/query
   {:query country-query
    :variables {:slug (:uri route)}}
   (fn [{:keys [client data error loading]}]
     (pages/page
      {:name "country"
       :title (-> data :country :name)}
      (cond
        error
        [:div "Error :("]
        loading
        [:div "Loading ..."]
        :else
        (let [{:keys [country]} data]
          (layout/grid
           {}
           (layout/row
            {}
            (layout/cell
             {:columns 12}
             [:h1.mdc-typography--headline5 (:name country)]
             (links/continent (:continent country))
             (lists/spots {:countries [(:id country)]})
             (lists/regions {:countries [(:id country)]}))))))))))

(when (exists? js/window)
  (loader/set-loaded! :country))
