(ns burningswell.web.fragments.introspection
  (:gen-class)
  (:require [grafiko.client :as client]
            [grafiko.lang.util :refer [clj->js underscore-keys]]
            [clojure.java.io :as io]))

(def default-file
  (io/file "src" "burningswell" "web" "fragments" "matcher.cljs"))

(def opts
  {:scheme :http
   :server-name "localhost"
   :server-port 8001})

(def query
  "The GraphQL query for the introspection fragment matcher."
  '((__schema (types kind name (possibleTypes name)))))

(defn filter-types [types]
  (filter :possibleTypes types))

(defn document-data [& [opts]]
  (-> (client/query query opts)
      :body :data
      (update-in [:--schema :types] filter-types)
      (underscore-keys)))

(defn document-str [data]
  (binding [*print-length* false *print-level* false]
    (with-out-str
      (prn '(ns burningswell.web.fragments.matcher
              (:require [apollo-cache-inmemory :refer [IntrospectionFragmentMatcher]])))
      (prn `(def ~'fragment-matcher
              (~'IntrospectionFragmentMatcher.
               ~(clj->js {:introspectionQueryResultData data})))))))

(defn -main [& args]
  (let [file (or (first args) default-file)]
    (spit file (document-str (document-data)))))

(comment (-main))
