(ns burningswell.web.core
  (:require ["@material/react-button" :default Button]
            ["@material/react-material-icon" :default Icon]
            [apollo.core :as a]
            [burningswell.web.system :as system]
            [burningswell.web.history :as history]
            [clojure.string :as str]
            [com.stuartsierra.component :as component]
            [react :as React :refer [createContext createElement]]
            [react-apollo :refer [ApolloProvider]]
            [react-dom :refer [hydrate]]
            [sablono.core :refer [defhtml html]]))

(defn apollo-provider [config child]
  (createElement ApolloProvider (clj->js (assoc config :children child))))

(defn button [text & [opts]]
  (createElement Button (clj->js (assoc opts :children text))))

(defn icon [type & [opts]]
  (createElement Icon (clj->js (assoc opts :icon (name type)))))

(defn user-name [user]
  (or (some->> [(:first_name user) (:last_name user)]
               (remove str/blank?)
               (not-empty)
               (str/join ""))
      (:username user)
      ;; TODO: Username should not be null
      (str (:id user))))
