(ns burningswell.web.ui.pages
  (:require [apollo.core :as a]
            [burningswell.web.ui.app-bar :as app-bar]
            [burningswell.web.ui.drawer :as drawer]
            [burningswell.web.viewport :as viewport]
            [sablono.core :refer [html]]))

(defn- class [opts]
  (str (name (:name opts)) "-page"))

(defn- content-class [opts]
  (str (class opts) "__content"))

(defn temporary
  [{:keys [name title] :as opts} & content]
  (html [:div.drawer-container
         {:class (class opts) :key (class opts)}
         (drawer/drawer {:dismissable? true :modal? true})
         (drawer/app-content
          (app-bar/app-bar
           {:navigation? true
            :title title})
          (html (into [:div.mdc-top-app-bar--fixed-adjust
                       {:class (content-class opts)
                        :key (content-class opts)}]
                      content)))]))

(defn permanent
  [{:keys [name title] :as opts} & content]
  (html [:div.drawer-container
         {:class (class opts) :key (class opts)}
         (drawer/drawer)
         (drawer/app-content
          (app-bar/app-bar {:title title})
          (html (into [:div.mdc-top-app-bar--fixed-adjust
                       {:class (content-class opts)
                        :key (content-class opts)}]
                      content)))]))

(defn page
  [opts & content]
  (a/query
   {:query viewport/query}
   (fn [{:keys [client data error loading] :as props}]
     (if (> (-> data :viewport :width) 800)
       (apply permanent opts content)
       (apply temporary opts content)))))
