(ns burningswell.web.ui.list
  (:refer-clojure :exclude [list])
  (:require ["@material/react-list" :default List :refer [ListDivider ListItem ListItemGraphic ListItemText]]
            ["@material/react-material-icon" :default Icon]
            [react :as React :refer [createElement]]
            [sablono.core :refer [html]]))

(defn- make-props [opts children]
  (clj->js (assoc opts :children (or children []))))

(defn divider [& [opts]]
  (createElement ListDivider (clj->js opts)))

(defn icon [type & [opts]]
  (createElement Icon (clj->js (assoc opts :icon (name type)))))

(defn item [opts & children]
  (createElement ListItem (make-props opts children)))

(defn item-graphic [opts]
  (createElement ListItemGraphic (clj->js opts)))

(defn item-text [opts]
  (createElement ListItemText (clj->js opts)))

(defn list [opts & children]
  (createElement List (make-props opts (remove nil? children))))
