(ns burningswell.web.ui.layout
  (:require ["@material/react-layout-grid" :refer [Cell Grid Row]]
            [react :as React :refer [createElement]]
            [sablono.core :refer [html]]))

(defn cell
  [{:keys [align class columns desktop phone tablet order]} & children]
  (apply createElement Cell
         #js {:align align
              :className class
              :columns columns
              :desktopColumns desktop
              :order order
              :phoneColumns phone
              :tabletColumns tablet}
         (html children)))

(defn grid
  [{:keys [align class]} & children]
  (apply createElement Grid
         #js {;; :align align
              :className class}
         (html children)))

(defn row
  [{:keys [class tag]} & children]
  (apply createElement Row
         #js {;; :tag tag
              :className class
              ;; :children children
              }
         (html children)))
