(ns burningswell.web.pages.signup
  (:require [apollo.core :as a]
            [burningswell.web.authentication :as auth]
            [burningswell.web.router :as router]
            [burningswell.web.ui.forms.signup :refer [signup-form]]
            [burningswell.web.ui.pages :as pages]
            [burningswell.web.ui.system :as system]
            [cljs.loader :as loader]
            [sablono.core :refer [html]]))

(defn on-signup
  [{:keys [authentication client router]} result]
  (some->> (-> result :signup :auth_token)
           (auth/save-auth-token! authentication))
  (a/reset-store! client)
  (router/to! router :home))

(defn main []
  (system/with-consumer [system]
    (pages/page
     {:name "signup"
      :title "Signup"}
     (html
      [:div
       [:h1.mdc-typography--headline5
        "Signup"]
       (signup-form
        {:id "signup-page"
         :on-signup #(on-signup system %)})]))))

(when (exists? js/window)
  (loader/set-loaded! :signup))
