(ns burningswell.web.stores.weather
  (:require [burningswell.web.stores.resources :as resources]
            [coolant.core :as coolant]
            [no.en.core :refer [deep-merge]]))

(defn update-spot-weather [state [spot weather]]
  (update-in state (resources/spot-path spot) deep-merge weather))

(def store
  "The weather store."
  (coolant/store
   :weather
   {}
   {:spot/weather update-spot-weather}))
