(ns burningswell.web.stores.signin
  (:require [coolant.core :as coolant]))

(defn update-login
  "Update the `value` of the login form field."
  [state value]
  (assoc-in state [:form :login] value))

(defn update-password
  "Update the `value` of the password form field."
  [state value]
  (assoc-in state [:form :password] value))

(defn update-remember-me
  "Update the `value` of the remember me form field."
  [state value]
  (assoc-in state [:form :remember-me] value))

(def store
  "The signin store."
  (coolant/store
   :signin
   {:errors
    {:login ""
     :password ""}
    :form
    {:login ""
     :password ""
     :remember-me false}
    :title "Signin"}
   {:signin/login update-login
    :signin/password update-password
    :signin/remember-me update-remember-me}))
