(ns burningswell.web.getter.search
  (:require [burningswell.web.getter.core :refer [layout]]
            [burningswell.web.stores.resources :as resources]
            [burningswell.web.stores.search :as search]
            [coolant.core :as coolant]))

(def query
  "The getter for the query."
  (coolant/getter
   [search/store]
   (fn [page]
     (:query page))))

(def results
  "The getter for the search results."
  (coolant/getter
   [search/store]
   (fn [page]
     (get-in page [:results (:query page)]))))

(def page
  "The getter for the search page."
  (coolant/getter
   [layout query results]
   (fn [layout query results]
     (->> {:query query
           :results results}
          (merge layout)))))
